export const dom = {
    mainConsoleSelector: document.getElementById('main-console-selector'),
    mainGameContainer: document.getElementById('main-game-container'),
    consoleSelectButton: document.getElementById('console-select-button'),
    consoleMenu: document.getElementById('console-menu'),
    consoleListUl: document.getElementById('console-list-ul'),
    gameListUl: document.getElementById('game-list'),
    gameScreenshotImg: document.getElementById('game-screenshot'),
    letterButtons: document.querySelectorAll('.letter-button'),
    letterJumpColumn: document.querySelector('.letter-jump'),
    gameSearchInput: document.getElementById('game-search'),
    buyMeABeerLink: document.getElementById('bottom-left-link'),
    youtubeLinkBottom: document.getElementById('youtube-link-bottom'),
    initialSelectionOverlay: document.getElementById('initial-selection-overlay'),
    initialConsoleListContainer: document.getElementById('initial-console-list-container'),
    initialConsoleListUl: document.getElementById('initial-console-list-ul'),
    versionMenuContainer: document.getElementById('version-menu-container'),
    versionButtonsDiv: document.getElementById('version-buttons'),
    versionMenuTitle: document.getElementById('version-menu-title'),
    tabMenuContainer: document.getElementById('tab-menu-container'),
    tabMenuButtonsDiv: document.getElementById('tab-menu-buttons'),
    changeConsoleButton: document.getElementById('change-console-button'),
    showLobbyButton: document.getElementById('show-lobby-button'),
    showFavoritesButton: document.getElementById('show-favorites-button'),
    showDownloadedButton: document.getElementById('show-downloaded-button'),
    searchGameButton: document.getElementById('search-game-button'),
    editUsernameButton: document.getElementById('edit-username-button'),
    relayConfigButton: document.getElementById('relay-config-button'),
    relayConfigValue: document.getElementById('relay-config-value'),
    powerOptionsButton: document.getElementById('power-options-button'),
    quitAppButton: document.getElementById('quit-app-button'),
    tabConsoleListContainer: document.getElementById('tab-console-list-container'),
    tabConsoleListUl: document.getElementById('tab-console-list-ul'),
    virtualKeyboardModalContainer: document.getElementById('virtual-keyboard-modal-container'),
    virtualKeyboardModal: document.getElementById('virtual-keyboard-modal'),
    virtualKeyboardTitle: document.getElementById('virtual-keyboard-title'),
    virtualKeyboardInput: document.getElementById('virtual-keyboard-input'),
    virtualKeyboardGrid: document.getElementById('virtual-keyboard-grid'),
    powerMenuContainer: document.getElementById('power-menu-container'),
    suspendButton: document.getElementById('suspend-button'),
    shutdownButton: document.getElementById('shutdown-button'),
    restartButton: document.getElementById('restart-button'),
    exitAppButton: document.getElementById('exit-app-button'),
    progressOverlay: document.getElementById('progress-overlay'),
    progressStatus: document.getElementById('progress-status'),
    progressBarContainer: document.getElementById('progress-bar-container'),
    progressBar: document.getElementById('progress-bar'),
    progressPercentText: document.getElementById('progress-percent'),
    progressInfoText: document.getElementById('progress-info-text'),
    progressCancelHint: document.getElementById('progress-cancel-hint'),
    progressCompletionButtons: document.getElementById('progress-completion-buttons'),
    progressAcceptButton: document.getElementById('progress-accept-button'),
    progressPlayNowButton: document.getElementById('progress-play-now-button'),
    supportPopupContainer: document.getElementById('support-popup-container'),
    supportPopupCloseButton: document.getElementById('support-popup-close'),
    supportPopupPatreonButton: document.getElementById('support-popup-patreon'),
    playDownloadMenuContainer: document.getElementById('play-download-menu-container'),
    playDownloadMenuTitle: document.getElementById('play-download-menu-title'),
    playButton: document.getElementById('play-game-button'),
    playOnlineButton: document.getElementById('play-online-button'),
    downloadOptionsButton: document.getElementById('download-options-button'),
    saveManageMenuContainer: document.getElementById('save-manage-menu-container'),
    saveManageMenuTitle: document.getElementById('save-manage-menu-title'),
    saveAppButton: document.getElementById('save-app-button'),
    saveComputerButton: document.getElementById('save-computer-button'),
    manageSavedButton: document.getElementById('manage-saved-button'),
    addToQueueButton: document.getElementById('add-to-queue-button'),
    savePromptContainer: document.getElementById('save-prompt-container'),
    savePromptTextElement: document.getElementById('save-prompt-text'),
    savePromptYesButton: document.getElementById('save-prompt-yes-button'),
    savePromptNoButton: document.getElementById('save-prompt-no-button'),
    lobbyMenuContainer: document.getElementById('lobby-menu-container'),
    lobbyListUl: document.getElementById('lobby-list-ul'),
    dynamicNotification: document.getElementById('dynamic-notification'),
    dynamicNotificationTitle: document.getElementById('dynamic-notification-title'),
    dynamicNotificationBody: document.getElementById('dynamic-notification-body'),
    dynamicNotificationLink: document.getElementById('dynamic-notification-link'),
    netplayStatusContainer: document.getElementById('netplay-status-container'),
    netplayTitle: document.getElementById('netplay-title'),
    netplaySubtitle: document.getElementById('netplay-subtitle'),
};

export const state = {
    paths: {
        imagesBasePath: '',
        iconsBasePathUrl: '',
        defaultImageUrl: '',
        welcomeImageUrl: '',
        logoUrl: '',
        scanlinesUrl: '',
        buttonsUrl: '',
        powerIcons: {}
    },
    navigationMode: 'initialConsoleList',
    selectedIndex: -1,
    letterButtonIndex: -1,
    activeLetterButton: null,
    gameItems: [],
    currentGames: [],
    allGames: {},
    availableConsoles: [],
    selectedConsoleName: '',
    arcadeTitles: {},
    favoriteGames: {},
    isShowingFavorites: false,
    isShowingDownloaded: false,
    isInitialSelectionActive: true,
    isConsoleMenuActive: false,
    isVersionMenuActive: false,
    isTabMenuActive: false,
    isVirtualKeyboardActive: false,
    isShiftActive: false, 
    isSupportPopupActive: false,
    isPlayDownloadMenuActive: false,
    isSaveManageMenuActive: false,
    isSavePromptActive: false,
    isLobbyMenuActive: false,
    isPowerMenuActive: false,
    shouldHighlightLetterButton: true,
    initialConsoleListItems: [],
    initialConsoleListItemIndex: -1,
    versionButtonIndex: -1,
    versionButtons: [],
    tabMenuButtonIndex: 0,
    tabMenuButtons: [],
    tabConsoleListItems: [],
    tabConsoleListItemIndex: -1,
    keyboardGrid: [], 
    keyboardButtonIndex: 0,
    onKeyboardConfirm: null, 
    supportPopupButtonIndex: 0,
    supportPopupButtons: [],
    playDownloadMenuIndex: 0,
    playDownloadMenuButtons: [],
    saveManageMenuIndex: 0,
    saveManageMenuButtons: [],
    savePromptButtonIndex: 0,
    savePromptButtons: [],
    lobbyGames: [],
    lobbySelectionIndex: -1,
    powerMenuButtonIndex: 0,
    powerMenuButtons: [],
    isEmuAppRunning: false,
    currentEmuAppPid: null,
    launchCounter: 0,
    currentOperationType: null,
    postCompletionTimeoutId: null,
    netplayAlertTimeoutId: null,
    selectedGameGroup: null,
    selectedGameGroupForMenu: null,
    currentGamePathForSaveMenu: null,
    currentGamePathForPlayDownloadMenu: null,
    currentGameBaseNameForPlayDownloadMenu: null,
    gameToLaunchAfterPopup: null,
    gamePathToPotentiallySave: null,
    platformForPotentialSave: null,
    lastSuccessfulGamePath: null,
    previousButtonStates: {},
    lastDirectionalInputTime: {},
    buttonPressedTime: {},
    isDownloading: false,
    downloadStartTime: null,
    downloadTimerId: null,
    notification: {
        data: null,
        timeoutId: null
    },
    relay: {
        options: [
            { label: "Disabled", server: "", enabled: "false" },
            { label: "North America", server: "nyc", enabled: "true" },
            { label: "Western Europe", server: "madrid", enabled: "true" },
            { label: "South America", server: "saopaulo", enabled: "true" },
            { label: "SouthEast Asia", server: "singapore", enabled: "true" },
            { label: "East Asia", server: "chuncheon", enabled: "true" },
        ],
        currentIndex: 0,
        initialIndex: 0,
    }
};

export const REPEAT_DELAY = 60;
export const INITIAL_REPEAT_DELAY = 350;
export const DOWNLOAD_TIMEOUT_MS = 30000;
export const LOBBY_SCAN_THRESHOLD = 3;
export const NETPLAY_CONSOLES = [
    'Arcade','Atari 2600', 'NEC TurboGrafx-16', 'NEC TurboGrafx-CD', 'Nintendo Entertainment System',
    'Nintendo Game Boy', 'Nintendo Game Boy Color', 'Nintendo Game Boy Advance', 'Nintendo Virtual Boy',
    'PC Engine SuperGrafx', 'Sega 32X', 'Sega CD', 'Sega Master System', 'Sega Genesis',
    'Sega Game Gear', 'Sega Saturn', 'Super Nintendo Entertainment System'
];
export const DISC_BASED_CONSOLES = [
    'NEC TurboGrafx-CD', 'Sony Playstation', 'Sony Playstation 2', 'Sony Playstation Portable',
    'Nintendo Gamecube', 'Nintendo Wii', 'Sega CD', 'Sega Saturn', 'Sega Dreamcast'
];